#|_________________________________________________________________________
 |
 | missplug.lsp
 | Copyright (c) 1998 by Pedro Valero (valerop@uv.es)
 | Code for Missing Data Analysis and Imputation. 
 |
 | PLUGIN CONSTRUCTOR FUNCTION
 |_________________________________________________________________________
 |#

; PLUGIN CONSTRUCTOR FUNCTION

(defun impute-missing-data
  (&key (data *current-data*)
        (dialog nil)
        (difference 0.0001)
        (iterations 200)
        (initial-matrix))
"Args: &key iterations difference initial-matrix data dialog
ViSta Missing Data Imputation plugin to impute values for missing elements in your data. 

  Since data with missing values cannot be used in ViSta's analysis methods, some way of pre-processing the data must be provided. This plugin provides three of the most common methods used to deal with missing data:
  1) LISTWISE DELETION: Any observation with a missing value is deleted from the dataset.
  2) PAIRWISE DELETION: Correlation/covariance matrices are computed on the basis of cases which do not have pairs of missing values.
  3) MAXIMUM LIKELIHOOD: An iterative process which attempts to obtain maximum likelihood estimates of the missing values. These estimates are used to replace the missing values so that no data has to be thrown out. 

  The maximum likelihood method is controlled by three of the arguments: It will iterate up to ITERATIONS times or until the improvement in the maximum likelihood from one iteration to the next is less than DIFFERENCE. The iterative process may be started at values you specify in INITIAL-MATRIX. The remaining keywords have their usual meaning. [CONSTRUCTOR]"

  (if (not (eq *current-object* data)) (setcd data))

  (send missing-data-model-object-proto
        :new "Impute Missing Data" data dialog 
        difference iterations initial-matrix))